// Define pins for the sensors
const int mq7Pin = A3;  // MQ-7 gas sensor connected to A3
const int ldrPin = A0;  // LDR connected to A0
const int tempPin = A1; // TMP36 temperature sensor connected to A1

void setup() {
  // Start serial communication
  Serial.begin(9600);
}

void loop() {
  // Read the analog values from the sensors
  int mq7Value = analogRead(mq7Pin);  // Read MQ-7 sensor value
  int ldrValue = analogRead(ldrPin);  // Read LDR sensor value
  int tempValue = analogRead(tempPin); // Read TMP36 temperature sensor value
  
  // Convert the TMP36 analog value to voltage
  float voltage = tempValue * (5.0 / 1023.0);  // Convert ADC value to voltage (0-5V)
  
  // Convert voltage to temperature (TMP36 specific formula)
  float temperature = (voltage - 0.5) * 100.0;  // Convert voltage to temperature in Celsius

  // Print the sensor values to the Serial Monitor
  Serial.print("MQ-7 Sensor Value: ");
  Serial.println(mq7Value);
  
  Serial.print("LDR Sensor Value: ");
  Serial.println(ldrValue);
  
  Serial.print("Temperature (Celsius): ");
  Serial.println(temperature);

  // Add a small delay between readings for better stability
  delay(1000); // Delay in milliseconds (1 second)
}
